<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thanks</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <style>
        *{
            padding: 0;
            margin: 0;
            box-sizing: border-box;
            font-family: "Raleway", sans-serif;
        }
        main{
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100%;
            min-height: 100vh;
            padding: 20px;
        }
        .box{
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            max-width: 600px;
            background: #fff;
        }
        .box img{
            width: 100px;
            margin-bottom: 20px;
        }
        .box h1{
            font-size: 32px;
            margin-bottom: 10px;
        }
        .box span{
            font-size: 18px;
            font-weight: 700;
        }
        .box p{
            font-size: 14px;
            margin-top: 5px;
        }
        .error h1 {
            color: red;
        }
        .success h1 {
            color: green;
        }
    </style>
</head>
<body>
<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'db.php';
require 'vendor/autoload.php'; // PHPMailer autoload

// Form data receive
$book_title  = $_POST['book_title'] ?? '';
$book_tagline = $_POST['book_tagline'] ?? '';
$authors_name = $_POST['authors_name'] ?? '';
$book_genre   = $_POST['book_genre'] ?? '';
$isbn         = $_POST['isbn'] ?? '';
$book_cover_size = $_POST['book_cover_size'] ?? '';
$back_cover_description = $_POST['back_cover_description'] ?? '';
$describe_your_book     = $_POST['describe_your_Book'] ?? '';
$categories = $_POST['category'] ?? '';
$user_email = $_POST['email'] ?? ''; // sirf record ke liye rakha, mail send nahi hoga

// SQL insert query
$sql = "INSERT INTO books_data 
(book_title, tagline, authors_name, genre, isbn, book_cover_size, back_cover_description, describe_your_book, design_category)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sssssssss", $book_title, $book_tagline, $authors_name, $book_genre, $isbn, $book_cover_size, $back_cover_description, $describe_your_book, $categories);

$success = false;
if ($stmt->execute()) {
    $success = true;

    // ==== Send Email (sirf admin ko) ====
    $mail = new PHPMailer(true);
    try {
        //Server settings
        $mail->isSMTP();
        $mail->Host = 'mail.amazonselfpub.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@amazonselfpub.com'; // Your Gmail
        $mail->Password = 'y*{a53[&_sF;';    // Your Gmail App Password
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        //Recipients (sirf admin)
        $mail->setFrom('info@amazonselfpub.com', 'Amazonselfpub ');
        $mail->addAddress('info@amazonselfpub.com', 'Amazonselfpub Admin');

        //Content
        $mail->isHTML(true);
        $mail->Subject = " New Book Submission Received";
        $mail->Body    = "
        <div style='font-family:Arial,sans-serif;padding:20px;background:#f9f9f9;'>
            <div style='max-width:600px;margin:auto;background:white;padding:30px;border-radius:10px;box-shadow:0 4px 12px rgba(0,0,0,0.1);'>
                <h2 style='color:#28a745;'>✅ New Submission Received</h2>
                <p><b>Author:</b> {$authors_name}</p>
                
                <table style='width:100%;border-collapse:collapse;margin-top:15px;'>
                    <tr><td><strong>📖 Title:</strong></td><td>{$book_title}</td></tr>
                    <tr><td><strong>🏷️ Tagline:</strong></td><td>{$book_tagline}</td></tr>
                    <tr><td><strong>✍️ Author:</strong></td><td>{$authors_name}</td></tr>
                    <tr><td><strong>📚 Genre:</strong></td><td>{$book_genre}</td></tr>
                    <tr><td><strong>🔖 ISBN:</strong></td><td>{$isbn}</td></tr>
                    <tr><td><strong>📦 Cover Size:</strong></td><td>{$book_cover_size}</td></tr>
                    <tr><td><strong>📝 Back Cover Description:</strong></td><td>{$back_cover_description}</td></tr>
                    <tr><td><strong>📌 Book Description:</strong></td><td>{$describe_your_book}</td></tr>
                    <tr><td><strong>📂 Categories:</strong></td><td>{$categories}</td></tr>
                </table>
                <p style='margin-top:20px;color:#555;'>Amazonselfpub</p>
            </div>
        </div>";
        $mail->AltBody = "New book submission: {$book_title} by {$authors_name} (Email: {$user_email})";

        $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: " . $mail->ErrorInfo);
    }

} else {
    $error_message = $stmt->error;
}

$stmt->close();
$conn->close();
?>
    <main>
        <div class="box <?php echo $success ? 'success' : 'error'; ?>">
            <?php if($success): ?>
                <img src="images/checklist.png" alt="Success">
                <h1>✅ Thank You!</h1>
                <span>Your form has been submitted successfully.</span>
                <p>Dear <b><?php echo htmlspecialchars($authors_name); ?></b>,  
                your book "<em><?php echo htmlspecialchars($book_title); ?></em>" is now saved in our system.</p>
            <?php else: ?>
                <h1>❌ Error!</h1>
                <span>Sorry, your submission failed.</span>
                <p>Error details: <?php echo htmlspecialchars($error_message ?? "Unknown error"); ?></p>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
