<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <title>Book Cover Design Query - Amazon Self Pub</title>
</head>
<body>
    <div class="form-container">
        <img src="images\logo.png" alt="">
        <form method="POST" action="thankyou.php">
            <h1 class="title">Initial Book Cover Design</h1>
            <div class="row mb-3">
                <div class="col-12 col-md-6">
                    <label class="form-label">Book Title</label>
                    <input type="text" name="book_title" class="form-control" required>
                </div>
                <div class="col-12 col-md-6">
                    <label class="form-label">Book Tagline</label>
                    <input type="text" name="book_tagline" class="form-control" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6">
                    <label class="form-label">Author's Name</label>
                    <input type="text" name="authors_name" class="form-control" required>
                </div>
                <div class="col-12 col-md-6">
                    <label class="form-label">Book Genre</label>
                    <input type="text" name="book_genre" class="form-control" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6">
                    <label class="form-label">ISBN</label>
                    <input type="text" name="isbn" class="form-control" required>
                </div>
                <div class="col-12 col-md-6">
                    <label class="form-label">Book Cover Size</label>
                    <input type="text" name="book_cover_size" class="form-control" required>
                </div>
            </div>
            <div class="row mb-3">
                <label class="form-label">Back Cover Description</label>
                <textarea row="5" name="back_cover_description" class="form-control"></textarea>
            </div>
            <div class="row mb-3">
                <label class="form-label"> Describe Your Book / Service / Organization / Genre</label>
                <textarea row="8" name="describe_your_Book" class="form-control"></textarea>
            </div>
            <div class="mb-3">
            <label class="form-label bold">Book Cover Design Categories</label>
            <div class="form-check">
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Picture Based" id="category1" checked>
                    <label class="form-check-label" for="category1">Picture Based</label>
                    <div class="item-images">
                        <img src="images/xl_media_image1.jpeg" alt="">
                        <img src="images/xl_media_image13.jpeg" alt="">
                        <img src="images/xl_media_image25.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Text Based" id="category2">
                    <label class="form-check-label" for="category2">Text Based</label>
                    <div class="item-images">
                        <img src="images/xl_media_image2.jpeg" alt="">
                        <img src="images/xl_media_image14.jpeg" alt="">
                        <img src="images/xl_media_image26.jpeg" alt="">
                    </div>
                </div>
                
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Picture Collage" id="category3">
                    <label class="form-check-label" for="category3">Picture Collage</label>
                    <div class="item-images">
                        <img src="images/xl_media_image3.jpeg" alt="">
                        <img src="images/xl_media_image15.jpeg" alt="">
                        <img src="images/xl_media_image27.jpeg" alt="">
                    </div>
                </div>
            
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Illustration" id="category4">
                    <label class="form-check-label" for="category4">Illustration</label>
                    <div class="item-images">
                        <img src="images/xl_media_image4.jpeg" alt="">
                        <img src="images/xl_media_image16.jpeg" alt="">
                        <img src="images/xl_media_image28.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Abstract" id="category5">
                    <label class="form-check-label" for="category5">Abstract</label>
                    <div class="item-images">
                        <img src="images/xl_media_image5.jpeg" alt="">
                        <img src="images/xl_media_image17.jpeg" alt="">
                        <img src="images/xl_media_image29.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Creative Illustration" id="category6">
                    <label class="form-check-label" for="category6">Creative Illustration</label>
                    <div class="item-images">
                        <img src="images/xl_media_image6.jpeg" alt="">
                        <img src="images/xl_media_image18.jpeg" alt="">
                        <img src="images/xl_media_image30.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Romantic" id="category7">
                    <label class="form-check-label" for="category7">Romantic</label>
                    <div class="item-images">
                        <img src="images/xl_media_image7.jpeg" alt="">
                        <img src="images/xl_media_image19.jpeg" alt="">
                        <img src="images/xl_media_image31.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Notebook" id="category8">
                    <label class="form-check-label" for="category8">Notebook</label>
                    <div class="item-images">
                        <img src="images/xl_media_image8.jpeg" alt="">
                        <img src="images/xl_media_image20.jpeg" alt="">
                        <img src="images/xl_media_image32.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Fictional" id="category9">
                    <label class="form-check-label" for="category9">Fictional</label>
                    <div class="item-images">
                        <img src="images/xl_media_image9.jpeg" alt="">
                        <img src="images/xl_media_image21.jpeg" alt="">
                        <img src="images/xl_media_image33.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Religious" id="category10">
                    <label class="form-check-label" for="category10">Religious</label>
                    <div class="item-images">
                        <img src="images/xl_media_image10.jpeg" alt="">
                        <img src="images/xl_media_image22.jpeg" alt="">
                        <img src="images/xl_media_image34.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Food & Recipes" id="category11">
                    <label class="form-check-label" for="category11">Food & Recipes</label>
                     <div class="item-images">
                        <img src="images/xl_media_image11.jpeg" alt="">
                        <img src="images/xl_media_image23.jpeg" alt="">
                        <img src="images/xl_media_image35.jpeg" alt="">
                    </div>
                </div>
                <div>
                    <input class="form-check-input" type="radio" name="category" value="Vintage" id="category12">
                    <label class="form-check-label" for="category12">Vintage</label>
                     <div class="item-images">
                        <img src="images/xl_media_image12.jpeg" alt="">
                        <img src="images/xl_media_image24.jpeg" alt="">
                        <img src="images/xl_media_image36.jpeg" alt="">
                    </div>
                </div>
            </div>
            <select class="form-select" id="categoriesSelect" name="categories[]">
                <option value="Picture Based" name="categories[]">Picture Based</option>
                <option value="Text Based" name="categories[]">Text Based</option>
                <option value="Picture Collage" name="categories[]">Picture Collage</option>
                <option value="Illustration" name="categories[]">Illustration</option>
                <option value="Abstract" name="categories[]">Abstract</option>
                <option value="Creative Illustration" name="categories[]">Creative Illustration</option>
                <option value="Romantic" name="categories[]">Romantic</option>
                <option value="Notebook" name="categories[]">Notebook</option>
                <option value="Fictional" name="categories[]">Fictional</option>
                <option value="Religious" name="categories[]">Religious</option>
                <option value="Food & Recipes" name="categories[]">Food & Recipes</option>
                <option value="Vintage" name="categories[]">Vintage</option>
            </select>
        </div>
        <button type="submit" class="btn">Submit</button>
        </form>
    </div>

    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            if (window.innerWidth <= 768) {
                $('#categoriesSelect').select2({
                    placeholder: "Select Categories",
                    width: '100%'
                });
            }
        });
    </script>
</body>
</html>