<?php
// php_upload_fix.php - Run this script to check and fix upload issues
echo "<h2>PHP Upload Configuration Check</h2>";

// Check current PHP settings
echo "<h3>Current PHP Settings:</h3>";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "post_max_size: " . ini_get('post_max_size') . "<br>";
echo "max_execution_time: " . ini_get('max_execution_time') . "<br>";
echo "max_input_time: " . ini_get('max_input_time') . "<br>";
echo "memory_limit: " . ini_get('memory_limit') . "<br>";

// Check uploads directory permissions
$upload_dir = "uploads/";
echo "<h3>Upload Directory Check:</h3>";
if (!file_exists($upload_dir)) {
    if (mkdir($upload_dir, 0755, true)) {
        echo "✅ Uploads directory created successfully<br>";
    } else {
        echo "❌ Failed to create uploads directory<br>";
    }
} else {
    echo "✅ Uploads directory exists<br>";
}

// Check directory permissions
echo "Upload directory permissions: " . substr(sprintf('%o', fileperms($upload_dir)), -4) . "<br>";
echo "Is writable: " . (is_writable($upload_dir) ? "✅ Yes" : "❌ No") . "<br>";

// Check disk space
echo "<h3>Disk Space:</h3>";
echo "Free space: " . round(disk_free_space(".") / (1024 * 1024), 2) . " MB<br>";
echo "Total space: " . round(disk_total_space(".") / (1024 * 1024), 2) . " MB<br>";

// Check temporary directory
echo "<h3>Temporary Directory:</h3>";
echo "upload_tmp_dir: " . (ini_get('upload_tmp_dir') ?: sys_get_temp_dir()) . "<br>";
echo "Temp dir writable: " . (is_writable(sys_get_temp_dir()) ? "✅ Yes" : "❌ No") . "<br>";

// Test file upload capability
echo "<h3>Upload Test:</h3>";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['testfile'])) {
    $test_file = $_FILES['testfile'];
    echo "File name: " . $test_file['name'] . "<br>";
    echo "File size: " . round($test_file['size'] / (1024 * 1024), 2) . " MB<br>";
    echo "File error: " . $test_file['error'] . "<br>";
    
    if ($test_file['error'] === UPLOAD_ERR_OK) {
        $target_path = $upload_dir . 'test_' . time() . '_' . $test_file['name'];
        if (move_uploaded_file($test_file['tmp_name'], $target_path)) {
            echo "✅ Test file uploaded successfully!<br>";
            unlink($target_path); // Clean up
        } else {
            echo "❌ Failed to move uploaded file<br>";
        }
    }
}
?>

<form method="post" enctype="multipart/form-data">
    <input type="file" name="testfile" required>
    <input type="submit" value="Test Upload">
</form>