<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Book Cover Design Query - Amazon Self Pub</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: "Raleway", sans-serif;
      background: linear-gradient(135deg, #f7f8fc, #eef1ff);
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }

    .form-container {
      background: #fff;
      max-width: 600px;
      width: 100%;
      border-radius: 20px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.1);
      padding: 40px;
      animation: fadeInUp 1s ease both;
    }

    @keyframes fadeInUp {
      from { opacity: 0; transform: translateY(40px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .form-container img {
      display: block;
      margin: 0 auto 20px;
      width: 140px;
    }

    .form-container h1.title {
      text-align: center;
      font-weight: 700;
      margin-bottom: 10px;
      color: #333;
    }

    .form-container p.subtitle {
      text-align: center;
      color: #666;
      font-size: 14px;
      margin-bottom: 30px;
    }

    .form-label {
      font-weight: 600;
      color: #444;
    }

    .form-control {
      border-radius: 10px;
      border: 1px solid #ccc;
      transition: all 0.3s ease;
    }

    .form-control:focus {
      border-color: #6c63ff;
      box-shadow: 0 0 8px rgba(108,99,255,0.3);
    }

    .btn {
      width: 100%;
      background: linear-gradient(135deg, #6c63ff, #857cff);
      border: none;
      border-radius: 10px;
      padding: 12px;
      color: #fff;
      font-weight: 600;
      font-size: 16px;
      transition: all 0.3s ease;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(108,99,255,0.3);
    }

    /* Upload box styling */
    .upload-box {
      border: 2px dashed #aaa;
      border-radius: 15px;
      padding: 25px;
      text-align: center;
      cursor: pointer;
      position: relative;
      overflow: hidden;
      transition: all 0.4s ease;
      background: #fafafa;
    }

    .upload-box:hover {
      border-color: #6c63ff;
      background: #f0f0ff;
    }

    .upload-box label {
      color: #6c63ff;
      font-weight: 600;
      cursor: pointer;
      display: block;
      font-size: 16px;
    }

    .upload-text {
      color: #777;
      font-size: 13px;
      margin-top: 8px;
    }

    .preview-container {
      margin-top: 15px;
      display: none;
      animation: fadeIn 0.5s ease;
    }

    .preview-image img {
      max-width: 150px;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }

    .preview-pdf {
      background: #f8f9fa;
      padding: 15px;
      border-radius: 10px;
      border: 2px solid #6c63ff;
    }

    .preview-pdf .pdf-icon {
      font-size: 48px;
      color: #e74c3c;
      margin-bottom: 10px;
    }

    .file-info {
      background: #e8f4fd;
      padding: 10px;
      border-radius: 8px;
      margin-top: 10px;
      font-size: 14px;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: scale(0.9); }
      to { opacity: 1; transform: scale(1); }
    }
  </style>
</head>
<body>

  <div class="form-container">
    <img src="images/logo.png" alt="Logo">
    <h1 class="title">Initial Book Cover Design</h1>
    <p class="subtitle">Fill out the form below to request your initial book cover design and attach reference images or files.</p>

    <form method="POST" action="submit_form.php" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">Name</label>
        <input type="text" name="name" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Genre</label>
        <input type="text" name="genre" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Message / Comments</label>
        <textarea name="message" class="form-control" rows="4" placeholder="Tell us about your book or design ideas..."></textarea>
      </div>

      <div class="mb-3 upload-box" id="uploadBox">
        <input type="file" id="file" name="file" accept="image/*,.pdf,.zip,.psd,.doc,.docx" hidden required>
        <label for="file">📎 Click or Drag & Drop to Upload</label>
        <div class="upload-text">Accepted: JPG, PNG, PDF, ZIP, PSD, DOC, DOCX (Max 25MB)</div>
        
        <!-- Image Preview -->
        <div class="preview-container preview-image" id="imagePreview">
          <img id="previewImg" src="#" alt="Image Preview">
        </div>
        
        <!-- PDF Preview -->
        <div class="preview-container preview-pdf" id="pdfPreview">
          <div class="pdf-icon">📄</div>
          <strong id="pdfFileName">PDF File</strong>
          <div class="file-info">
            <span id="fileSize">0 KB</span> • <span id="fileType">PDF</span>
          </div>
        </div>
      </div>

      <button type="submit" class="btn">Submit Request</button>
    </form>
  </div>

  <script>
    const fileInput = document.getElementById('file');
    const imagePreview = document.getElementById('imagePreview');
    const pdfPreview = document.getElementById('pdfPreview');
    const previewImg = document.getElementById('previewImg');
    const pdfFileName = document.getElementById('pdfFileName');
    const fileSize = document.getElementById('fileSize');
    const fileType = document.getElementById('fileType');
    const uploadBox = document.getElementById('uploadBox');

    fileInput.addEventListener('change', function() {
      const file = this.files[0];
      
      // Hide both previews first
      imagePreview.style.display = 'none';
      pdfPreview.style.display = 'none';
      
      if (file) {
        // Display file information
        pdfFileName.textContent = file.name;
        fileSize.textContent = formatFileSize(file.size);
        fileType.textContent = getFileType(file.type);
        
        if (file.type.startsWith('image/')) {
          // Show image preview
          const reader = new FileReader();
          reader.onload = function(e) {
            previewImg.src = e.target.result;
            imagePreview.style.display = 'block';
          }
          reader.readAsDataURL(file);
        } else if (file.type === 'application/pdf' || file.name.toLowerCase().endsWith('.pdf')) {
          // Show PDF preview
          pdfPreview.style.display = 'block';
        } else {
          // Show generic file preview for other types
          pdfPreview.style.display = 'block';
          document.querySelector('.pdf-icon').textContent = '📎';
        }
      }
    });

    // Format file size
    function formatFileSize(bytes) {
      if (bytes === 0) return '0 Bytes';
      const k = 1024;
      const sizes = ['Bytes', 'KB', 'MB', 'GB'];
      const i = Math.floor(Math.log(bytes) / Math.log(k));
      return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }

    // Get file type description
    function getFileType(mimeType) {
      const types = {
        'image/jpeg': 'JPEG Image',
        'image/png': 'PNG Image',
        'image/gif': 'GIF Image',
        'application/pdf': 'PDF Document',
        'application/zip': 'ZIP Archive',
        'application/x-photoshop': 'PSD File',
        'application/msword': 'Word Document',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'Word Document'
      };
      return types[mimeType] || mimeType;
    }

    // Drag and drop animation
    uploadBox.addEventListener('dragover', (e) => {
      e.preventDefault();
      uploadBox.style.borderColor = '#6c63ff';
      uploadBox.style.background = '#f0f0ff';
    });

    uploadBox.addEventListener('dragleave', () => {
      uploadBox.style.borderColor = '#aaa';
      uploadBox.style.background = '#fafafa';
    });

    uploadBox.addEventListener('drop', (e) => {
      e.preventDefault();
      uploadBox.style.borderColor = '#aaa';
      uploadBox.style.background = '#fafafa';
      const file = e.dataTransfer.files[0];
      if (file) {
        fileInput.files = e.dataTransfer.files;
        
        // Trigger change event manually
        const event = new Event('change');
        fileInput.dispatchEvent(event);
      }
    });
  </script>
</body>
</html>