<?php
// cleanup.php - Run this to clean up temporary files and check space
echo "<h2>Disk Space Cleanup Utility</h2>";

// Check current disk space
$free_space = disk_free_space(".");
$total_space = disk_total_space(".");
$free_mb = round($free_space / (1024 * 1024), 2);
$total_mb = round($total_space / (1024 * 1024), 2);

echo "<h3>Current Disk Status:</h3>";
echo "Free space: <strong>$free_mb MB</strong><br>";
echo "Total space: $total_mb MB<br>";
echo "Used space: " . round(($total_space - $free_space) / (1024 * 1024), 2) . " MB<br>";

// Clean uploads directory
echo "<h3>Cleaning Uploads Directory:</h3>";
$upload_dir = "uploads/";
if (file_exists($upload_dir)) {
    $files = glob($upload_dir . "*");
    $deleted_count = 0;
    $deleted_size = 0;
    
    foreach ($files as $file) {
        if (is_file($file)) {
            $file_size = filesize($file);
            if (unlink($file)) {
                $deleted_count++;
                $deleted_size += $file_size;
                echo "✅ Deleted: " . basename($file) . " (" . round($file_size / 1024, 2) . " KB)<br>";
            }
        }
    }
    
    echo "<strong>Total freed: $deleted_count files, " . round($deleted_size / (1024 * 1024), 2) . " MB</strong><br>";
}

// Check space after cleanup
$new_free_space = disk_free_space(".");
$new_free_mb = round($new_free_space / (1024 * 1024), 2);
echo "<h3>After Cleanup:</h3>";
echo "Free space: <strong>$new_free_mb MB</strong><br>";

if ($new_free_mb > 50) {
    echo "✅ Sufficient space available for uploads!";
} else {
    echo "❌ Still insufficient space. Please free up more disk space.";
}
?>